/*****************************************************************************
*  LPC15xx SCT demo
*  Use SCT3 as unified timer to toggle SCT3_OUT0 every 100 msec
*  LPC15xx  - SCT0/1 support:  8 inputs
*                              10 outputs
*                              16 match/capture registers
*                              16 events
*                              16 states
*             SCT2/3 support:  3 inputs
*                              6 outputs
*                              8 match/capture registers
*                              10 events
*                              10 states
*****************************************************************************/
#include "LPC15xx.h"

void SCT3_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= EN1_SCT3;                // enable the SCT3 clock

    LPC_SCT3->CONFIG |= 1;                                 // unified timer

    LPC_SCT3->MATCH[0].U     = (SystemCoreClock/10)-1;     // match 0 @ 100 msec
    LPC_SCT3->MATCHREL[0].U  = (SystemCoreClock/10)-1;

    LPC_SCT3->EVENT[0].STATE = 0x00000001;                 // event 0 only happens in state 0
    LPC_SCT3->EVENT[0].CTRL  = (0 << 0)  |                 // related to match 0
                               (1 << 12) |                 // COMBMODE[13:12] = match condition only
//                             (1 << 14) |                 // STATELD[14] = STATEV is loaded into state
                               (0 << 14) |                 // STATELD[14] = STATEV is added to state
                               (1 << 15);                  // STATEV[15] = 1 (new state is 0 + 1 = 1)

    LPC_SCT3->EVENT[1].STATE = 0x00000002;                 // event 1 only happens in state 1
    LPC_SCT3->EVENT[1].CTRL  = (0 << 0)  |                 // related to match 0
                               (1 << 12) |                 // COMBMODE[13:12] = match condition only
//                               (1 << 14) |                 // STATELD[14] = STATEV is loaded into state
                               (0 << 14) |                 // STATELD[14] = STATEV is added to state
                               (31 << 15);                 // STATEV[15] = 31 (new state is (1 + 31)mod32 = 0)

    LPC_SCT3->OUT[0].SET     = (1 << 0);                   // event 0 will set SCT_OUT_0
    LPC_SCT3->OUT[0].CLR     = (1 << 1);                   // event 1 will clear SCT_OUT_0
    LPC_SCT3->LIMIT_L        = 0x0003;                     // events 0 and 1 are used as counter limit

    LPC_SCT3->CTRL_L        &= ~(1 << 2);                  // unhalt it by clearing bit 2 of the CTRL register
}
